/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System.ComponentModel;
using System.Drawing;

using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.Subscription;
using Borland.Eco.UmlRt;

namespace Borland.Eco.Handles
{
	public abstract class AbstractCursorHandle: RootedHandle
	{
		protected override IClassifier GetStaticUmlType()
		{
			if (RootHandle == null)
				return null;
			return HandleUtils.ItemType(EffectiveRootStaticContext.StaticUmlType);
		}

		/// <summary>
		/// Sets and gets the position in the list pointed to by the handle.
		/// </summary>
		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public abstract int Position
		{
			get;
			set;
		}

		protected override void DeriveAndSubscribe(ISubscriber valueChangeSubscriber, ISubscriber resubscribeSubscriber)
		{
			if (Active)
			{
				IElement rootValue = EffectiveRootValue();
				IOclService oclService = (IOclService)GetEcoService(typeof(IOclService));
				if (oclService != null) 	// this is just to get the subscriptions
					oclService.EvaluateAndSubscribe(rootValue, EffectiveVariables(), "" /*Expression*/, valueChangeSubscriber, resubscribeSubscriber);

				if ((rootValue != null) &&
					(Position != -1))
				{
					IElementCollection ec = RootHandle.Element.GetAsCollection();
					if (ec.Count > Position)
						InternalElement = RootHandle.Element.GetAsCollection()[Position];
					else
						InternalElement = null;
				}
				else
					InternalElement = null;
			}
			else
			{
				InternalElement = null;
			}
		}
	}

	/// <summary>
	/// <para>Handle whose value is an element in a list and the position is set manually.</para>
	/// <para>Primarily intended for ASP apps.</para>
	/// </summary>
	[ToolboxBitmap(typeof(CursorHandle), "Borland.Eco.Handles.CursorHandle.bmp")]
	[ToolboxItem(true)]
	public sealed class CursorHandle: AbstractCursorHandle
	{
		public CursorHandle(): base() {}
		private int m_Position = -1;

		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public override int Position
		{
			get { return m_Position;}
			set
			{
				if (value != m_Position)
				{
					m_Position = value;
					MarkSubscriptionOutOfDate();
				}

			}
		}
	}
}